<?php
add_action('admin_menu', 'xf_admin_menu');
function xf_admin_menu() {
	add_options_page('XenForo Options','XenForo','manage_options','xf_options','xf_admin_page');
}

add_action('admin_init', 'xf_admin_init'); 
function xf_admin_init() {
	register_setting('xf-settings-group', 'xf_path');
	register_setting('xf-settings-group', 'xf_roles_map');
	register_setting('xf-settings-group', 'xf_globalSalt');
	if (class_exists('XenForo_WP')) {
		if (defined('IS_PROFILE_PAGE')) {
			XenForo_WP::create()->redirect('account');
		}
		if ($GLOBALS['parent_file'] == 'users.php') {
			wp_safe_redirect(XenForo_WP::create()->options['boardUrl'] . '/admin.php?users/');
		}
		// should we redirect user-edit.php or not?
	}
}

function xf_admin_page_roles($fieldname,$selected = null) {
	static $names = null;
	if (empty($names)) {
		global $wp_roles;
		if (!isset($wp_roles)) {
			require_once( ABSPATH . WPINC . '/capabilities.php');
			$wp_roles = new WP_Roles();
		}
		$names = $wp_roles->get_names();
	}
?>
<select name="<?php echo $fieldname; ?>">
	<option value=""><?php echo __('Default'); ?></option>
<?php foreach ($names as $varname => $displayname): ?>
	<option value="<?php echo $varname; ?>"<?php if ($varname == $selected): ?> selected="selected"<?php endif; ?>><?php echo $displayname; ?></option>
<?php endforeach; ?>
</select>
<?php
}

function xf_admin_page() {
	if (!current_user_can('manage_options'))  {
		wp_die(__('Oops. Permission denied?!') );
	}
	if (class_exists('XenForo_WP')) {
		$usergroups = XenForo_WP::create()->getUsergroups();
		$roles_map =& XenForo_WP::create()->options['roles_map'];
	} else {
		$usergroups = array();
		$roles_map = array();
	}
?>
<div class="wrap">
<h2>XenForo</h2>
<form method="post" action="options.php">
	<?php settings_fields('xf-settings-group'); ?>
	<table class="form-table">
		<tr valign="top">
		<th scope="row" nowrap="nowrap"><?php echo __('XenForo Path'); ?></th>
		<td>
			<div>
				<input type="text" name="xf_path" value="<?php echo get_option('xf_path'); ?>" class="regular-text"/>
				<?php if (class_exists('XenForo_WP')): ?><span style="color: green; font-weight: bold"><?php echo __('Found') ?></span><?php endif; ?>
			</div>
			<div><?php echo __('Absolute path <strong>/home/www/xenforo/</strong> OR relative path <strong>../xenforo/</strong> both works fine') ?></div>
		</td>
		</tr>
		<tr valign="top">
		<th scope="row" nowrap="nowrap"><?php echo __('XenForo globalSalt'); ?></th>
		<td>
			<div>
				<input type="text" name="xf_globalSalt" value="<?php echo get_option('xf_globalSalt'); ?>" class="regular-text"/>
			</div>
			<div>
				<?php echo __('Instruction') ?>:<br/>
				<ol>
					<li><?php echo __('Please open up your XenForo\'s library/XenForo/Application.php, find "globalSalt" and copy it\'s value') ?>. 
					<?php echo sprintf(__('For example, if you find %1$s, please copy <strong>1111a1a1111111a11111a1a11111aaa1</strong> into this field'),highlight_string("'globalSalt' => '1111a1a1111111a11111a1a11111aaa1'",true)) ?></li>
					<li><?php echo __('OR, you can leave this field empty and open your XenForo\'s library/config.php and put this line into it. Remember to use a random string') ?>:
					<?php highlight_string("\$config['globalSalt'] = 'random-string-goes-here';") ?></li>
				</ol>
			</div>
		</td>
		</tr>
		<?php foreach ($usergroups as $usergroup): ?>
		<tr valign="top">
		<th scope="row" nowrap="nowrap"><?php echo __('Role for') . ' ' . $usergroup->title . ' (#' . $usergroup->user_group_id . ')'; ?></th>
		<td><?php xf_admin_page_roles('xf_roles_map[' . $usergroup->user_group_id . ']', @$roles_map["{$usergroup->user_group_id}"]); ?></td>
        </tr>
		<?php endforeach; ?>
	</table>
	
	<p class="submit">
	<input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
	</p>
</form>
</div>
<?php
}
/* XenForo rocks. Admit it! */